package gov.va.med.mhv.usermgmt.util;

import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.usermgmt.common.enums.ExtractType;
import gov.va.med.mhv.usermgmt.data.model.AccessControl;
import gov.va.med.mhv.usermgmt.service.AccessControlService;

@Component
public final class PHRAccessControl {

	private static final Log log = LogFactory.getLog(PHRAccessControl.class);

	@Autowired
	private AccessControlService accessControlService;

	private PHRAccessControl() {
	}

	public boolean hasPhrAccess(Patient patient, ResponseUtil response) {
		Precondition.assertNotNull("patient", patient);
		Precondition.assertNotNull("patient.userProfile", patient.getUserProfile());
		return hasPhrAccess(patient.getUserProfile().getUserName(), response);
	}

	public boolean hasPhrAccess(String userName, ResponseUtil response) {
		Precondition.assertNotBlank("userName", userName);
		return hasPhrAccess(ExtractTypeUtils.getAllExtractTypes(), userName, response);
	}

	public boolean hasPhrAccess(ExtractType extractType, Patient patient, ResponseUtil response) {
		Precondition.assertNotNull("extractType", extractType);
		Precondition.assertNotNull("patient", patient);
		Precondition.assertNotNull("patient.userProfile", patient.getUserProfile());
		ExtractType[] extractTypes = {
			extractType
		};
		return hasPhrAccess(extractTypes, patient.getUserProfile().getUserName(), response);
	}

	@SuppressWarnings("unchecked")
	private boolean hasPhrAccess(ExtractType[] extractTypes, String userName, ResponseUtil response) {
		assert extractTypes != null;
		assert !StringUtils.isBlank(userName);
		accessControlService.findAccessControls(userName, response);
		
		if (response.isFailure()) {
			if (log.isErrorEnabled()) {
				log.error("Unable to determine patient " + userName + " access to extracts '" + extractTypes + "'");
			}
			return false;
		}

		Collection<AccessControl> accessControls = (Collection<AccessControl>) response.getPojoObject();
		if (accessControls == null) {
			return false;
		}

		for (ExtractType extractType : extractTypes) {
			if (hasPhrAccess(extractType, userName, accessControls, response)) {
				return true;
			}
		}
		return true;
	}

	private static boolean hasPhrAccess(ExtractType extractType, String userName, Collection<AccessControl> accessControls, ResponseUtil response) {
		assert extractType != null;
		assert !StringUtils.isBlank(userName);
		boolean hasAccess = false;
//		if ((accessControls != null)) {
//			hasAccess = AccessControlUtils.hasAccess(AccessDomainEnum.PHR, extractType.getName(), AccessPermission.READ, accessControls);
//		}
		if (log.isDebugEnabled()) {
			log.debug("Patient " + userName + " has " + (hasAccess ? "" : "NO ") + " access to extract '" + extractType.getName() + "'");
		}
		return hasAccess;
	}

}
